	/*
	** Open Raster Options
	*/
	frame choosesymb;
	variable inopenfile;
	global imagenbands;
	global evssetfrom;
	global evspath;

    on startup {
		set inopenfile = 0;
	}

	frame raster_options {
                geometry 0,0,388,295;
                titleoffset 0;
		textnumber red;
		textnumber green;
		textnumber blue;
		textnumber gray;
		popuplist filetype;
		group layersgroup;
		group singlelayergroup;
		button OK;
		label numberoflayers;
		label numberrows;
		label numberofcolumns;
		variable vdorl;
		title "Options";

                group optionsgroup {
                        title above left "Raster Options";
                        geometry 0,0,388,295;
                        titleoffset 0;


			popuplist filetype {
                                title left center "Display as :";
                                geometry 5,5,250,30;
                                titleoffset 0;
                                names {"truecolor", "pseudocolor", "grayscale", "relief"};
				titlelist {"True Color", "Pseudo Color", "Gray Scale", "Relief"};

				on valuechanged {

					if ( $filetype == "truecolor" ) {
					   hide singlelayergroup;
					   show layersgroup;
					}
					elsif ( $filetype == "grayscale" ) {
					   hide layersgroup;
					   show singlelayergroup;
					}
					elsif ( $filetype == "pseudocolor" ) {
					   hide layersgroup;
					   show singlelayergroup;
					}
					elsif ( $filetype == "relief" ) {
					   hide layersgroup;
					   show singlelayergroup;
					}
					else {
					   hide layersgroup;
					   show singlelayergroup;
					}
				}
			}

			group layersgroup {
				title above center "Layers to Colors:";
				info "Set Layer Combinations";
				below left filetype;
				size 22.6,2;
			 
				label redlabel {
					value "Red:";
					at 0,0.2;
					foreground "red";
				}
			 
				textnumber red { 
						 min 1;
						 max $imagenbands;
						 size 4.25,1.5;
						 at 2.75,0.1;
				}
				
				label greenlabel {
					value "Green:";
					foreground "green";
					at 7,0.2;
				}
				
				textnumber green { 
						   at 10.75,0.1; 
						   min 1;
						   max $imagenbands;
						   size 4.25,1.5;
				}
				
				label bluelabel {
					value "Blue:";
					foreground "blue";
					at 15,0.2;
				}
				
				textnumber blue { 
						  at 18,0.1; 
						  min 1;
						  max $imagenbands;
						  size 4.75,1.5;
				}
			}
			
			group singlelayergroup {
				title above center "Display Layer:";
				info "Gray Scale Band";
				below left filetype;
				size 22.6,2;
				
				textnumber gray { 
						 title left center "Layer:";
						 at 10,0.1;
						 min 1;
						 max $imagenbands;
						 size 4.75,1.5;
				}
			}
                   
            button helpbutton {
                title "Help";
                size 4, 1.5;
                    below center layersgroup;
                    on mousedown {
						showhelp "isworkstation" "raster_options" "helpbutton";
					}
		   }
                    
            }

                on filenamechoosen with fname do {
			set openoverlayfile = $fname;
			set imagenbands = $openoverlayfile.nbands;
 			enable layersgroup;
 			enable singlelayergroup;

 		   	if (  $openoverlayfile.nbands != 0  ) {
					
				if ( $openoverlayfile.filetype == "truecolor" ) {
					set filetype = "truecolor";
				}
				
				elsif ( $openoverlayfile.filetype == "pseudocolor" ) {
					set filetype = "pseudocolor";
				}
			
				else {
					set filetype = "grayscale";
					hide layersgroup;
					show singlelayergroup;
				}	
				
				
				set numberoflayers = $openoverlayfile.nbands;
				set numberrows = $openoverlayfile.height;
				set numberofcolumns = $openoverlayfile.width;
				set gray = 1;

						
				if ( $openoverlayfile.nbands < 3 ) {
					set red   = 1;
					set green = 1;
					set blue  = 1; 
				}
			
				elsif ( $openoverlayfile.nbands == 3 ) {
					set red   = getpref("eml" "spot_default_red_band");
					set green = getpref("eml" "spot_default_green_band");
					set blue  = getpref("eml" "spot_default_blue_band"); 
				}
			
				elsif ( $openoverlayfile.nbands == 4 ) {
					set red   = getpref("eml" "mss_default_red_band");
					set green = getpref("eml" "mss_default_green_band");
					set blue  = getpref("eml" "mss_default_blue_band"); 
				}
			
				elsif ( $openoverlayfile.nbands == 5 ) {
					set red   = getpref("eml" "avhrr_default_red_band");
					set green = getpref("eml" "avhrr_default_green_band");
					set blue  = getpref("eml" "avhrr_default_blue_band"); 
				}
			
				else {	
					set red   = getpref("eml" "tm_default_red_band");
					set green = getpref("eml" "tm_default_green_band");
					set blue  = getpref("eml" "tm_default_blue_band"); 
				}


                	}
			else {
				showmessage ( "Raster file has no layers!" );
				set filetype = "grayscale";
				hide layersgroup;
				show singlelayergroup;
				set numberoflayers = $openoverlayfile.nbands;
				set gray = 0;
			}
        	}
	 }
	
	/*
	** Vector Options
	*/
	frame vector_options {
		checkbox usesymb;
		label symblabel;
		button setsymb;
		variable vdovl;
		variable checkpath;
		variable checkpref;
    		title "Options";		
		 
		group vectorspecs {
                        title above left "Vector Options";
                        geometry 0,0,368,295;
			titleoffset 0;

			checkbox usesymb {
				title "Use Symbology";
				geometry 20,21,119,26;
				info "Use Symbology for Display Vector Data";
				on valuechanged {
					if($usesymb == 1) {
						enable symblabel;
						enable setsymb;
					}
					else {
						disable symblabel;
						disable setsymb;
					}
				}
			}
			 
			checkbox cleardisp {
				title "Clear Display";
				below left usesymb;
				info "Clear Window Before Displaying Vector Data";
			}
			
			label symblabel {
				title "Option:";
				geometry 20,85,340,18;
				below left cleardisp;
				value "None Defined";
				info "Symbology Option";
			}
			
			button setsymb {
				title "Set ...";
				geometry 20,109,56,25;
				below left symblabel;
				info "Set Symbology for Vector Data";
				on mousedown {
					set evssetfrom = "openvectorlayer";
					display choosesymb;
				}
			}
			button helpbutton {
				title "Help";
				geometry 290,240,70,25;
				on mousedown {
                                	showhelp "viewer" "vector_options" "helpbutton";
				}
			}
		}
	 	
		/*
		** After a vector layer is selected, set the symbology
		** file on the vector_options frame by using a default
		** or a *.evs file assoiciated with that layer.
		*/
		on filenamechoosen with flist do {
			if ($flist != "") {
				set usesymb = 1;
				set checkpath = fpath($flist) + froot($flist) + ".evs";
				set checkpref = getpref("viewer" "default_symbology");
				
				if (fexist($checkpath)) {
					set evspath = $checkpath;
					set symblabel = $checkpath;
				}
				elsif ((fexist($checkpref))&&($checkpref != "")) {
					set evspath = $checkpref;
					set symblabel = $checkpref;
				}
				else {
					set evspath = getpref("eml" "default_data_path")+"/*.evs";
					set symblabel = "None Defined";
					set usesymb = 0;
				}
			}
			else {
				set usesymb = 0;
				set evspath = getpref("eml" "default_data_path")+"/*.evs";
			}
		}
		on framedisplay {
			set cleardisp = 0;
			disable cleardisp;
			set usesymb = 0;
		}

	 }

     
	/*********************************************************************
	**
	** choose symbology
	** 
	*********************************************************************
	*/
	frame choosesymb {
		title "Choose Symbology";  
		at 100,120;
		modal;
		button OK;	 	 
	 	 
	 	 filename input {
	 	 	title "Vector Layer:";
	 	 	size 16.5,12;
	 	 	at 1,0.2;
			select getpref("eml" "default_data_path")+"/*.evs";
			filetypedef "Symbology (*.evs)";
			on doubleclick send mousedown to OK;
			on input {
				if ($input != "") {
					enable OK;
				}
				else {
					disable OK;
				}
			}
	 	 }	
	 	 	 						
	 	button OK {
	 		title "OK";
			at 0.2,13.75;
			size 6,1.5;
			on mousedown {
				if ( $evssetfrom == "openvectorlayer" ) {
					set isworkstation:vector_options:symblabel = $input;
				}
				undisplay choosesymb;
			}
	 	}
	 	 	 
	  	button cancel {
	 		title "Cancel";
	 		rightof OK nogap;
	 		size 6,1.5;
	 		on mousedown {
	 			undisplay choosesymb;
	 		}
	 	}
	 	
	 	button helpbutton {
	 		title "Help";
	 		rightof cancel nogap;
	 		size 6,1.5;
	 		on mousedown {
	 			showhelp;
	 		}
	 	}
	 	
	 	on framedisplay {
	 		set input = $evspath;
	 	}
	 }

	/*
	** Functions called for
	** Different layer types
	*/
	on onopenoverlayfile (template) {

		if ($inopenfile == 0)  {
			set inopenfile = 1;

			/*
			** TEMPORARY FIX UNTIL THE FILECHOOSER WILL
			** COPY THE CONTEXT FROM THE FRAME FOR APPLICATION
			** FUNCTIONS (getresamplemethods, callibtype)
			*/
			MenuSetTemporaryViewer();

			/*
			** klooj to get the file chooser to retain the last type
			** selected when the template is not specified...otherwise
			** the behavior is VERY ANNOYING because the chooser type
			** keeps getting reset back to some default
			*/
			if ( $template == "" )
			{
				variable myempty;
				if ($openoverlayfile.QueryForFilename($myempty) == 0) {
					set inopenfile = 0;
					return;
				}
			}
			else
			{
				if ($openoverlayfile.QueryForFilename($template) == 0) {
					set inopenfile = 0;
					return;
				}
			}
			set inopenfile = 0;

			switch ( $openoverlayfile.GetCategory()) {

			case "raster": OpenRasterLayer($openoverlayfile );
			case "Annotation": OpenAnnotationLayer( $openoverlayfile );
			case "AOI": OpenAoiLayer( $openoverlayfile );
			case "vector": OpenVectorLayer( $openoverlayfile );
			else : MenuPluginAddLayer($openoverlayfile, $openoverlayfile.GetCategory());

			}

		}
	}

	/*
	** Open Raster Layer Function
	*/
	on openrasterlayer with imagename do {

		if ( $openoverlayfile.nbands <= 0 ) {
			showmessage ( "Raster file has no layers!" );
			return;
		}

		OpenOverlayRasterLayer($imagename, 
			$isworkstation:raster_options:filetype,
			$isworkstation:raster_options:red , 
			$isworkstation:raster_options:green, 
			$isworkstation:raster_options:blue,
			$isworkstation:raster_options:gray);
 	}



	on openannotationlayer with imagename do {
		OpenOverlayAnnotationLayer($imagename);
	}



	on openvectorlayer with imagename do {
		OpenOverlayVectorLayer($imagename, $isworkstation:vector_options:usesymb,
			$isworkstation:vector_options:symblabel);
	}


	on openaoilayer with imagename do {
        OpenOverlayAoiLayer($imagename);
	}
